/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.trees.J48;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PartitionMembership;

public class PartitionMembershipTest
extends AbstractFilterTest {
    public PartitionMembershipTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        int i = 0;
        while (i < this.m_Instances.numAttributes()) {
            if (!this.m_Instances.attribute(i).isNominal() && !this.m_Instances.attribute(i).isNumeric() || this.m_Instances.attribute(i).isDate()) {
                this.m_Instances.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
        this.m_Instances.setClassIndex(0);
    }

    @Override
    public Filter getFilter() {
        PartitionMembership f = new PartitionMembership();
        return f;
    }

    @Override
    protected FilteredClassifier getFilteredClassifier() {
        FilteredClassifier result = new FilteredClassifier();
        result.setFilter(this.getFilter());
        result.setClassifier(new J48());
        return result;
    }

    @Override
    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = TestInstances.forCapabilities(this.m_FilteredClassifier.getCapabilities());
        test.setClassIndex(-1);
        Instances result = test.generate();
        return result;
    }

    public void testNominal() {
        this.m_Filter = this.getFilter();
        this.m_Instances.setClassIndex(0);
        Instances result = this.useFilter();
        PartitionMembershipTest.assertEquals(this.m_Instances.numClasses(), result.numClasses());
        PartitionMembershipTest.assertTrue(result.numAttributes() >= 2);
    }

    public void testNumeric() {
        this.m_Filter = this.getFilter();
        this.m_Instances.setClassIndex(2);
        Instances result = this.useFilter();
        PartitionMembershipTest.assertTrue(result.numAttributes() >= 2);
    }

    public static Test suite() {
        return new TestSuite(PartitionMembershipTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(PartitionMembershipTest.suite());
    }
}

